/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TestInstances;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.estimators.Estimator;
import weka.estimators.IncrementalEstimator;
import weka.estimators.NormalEstimator;

public class CheckEstimator
implements OptionHandler,
RevisionHandler {
    protected Estimator m_Estimator = new NormalEstimator(1.0E-6);
    protected String[] m_EstimatorOptions;
    protected String m_AnalysisResults;
    protected boolean m_Debug = false;
    protected boolean m_Silent = false;
    protected int m_NumInstances = 100;
    protected PostProcessor m_PostProcessor = null;
    protected boolean m_ClasspathProblems = false;

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\tTurn on debugging output.", "D", 0, "-D"));
        newVector.addElement(new Option("\tSilent mode - prints nothing to stdout.", "S", 0, "-S"));
        newVector.addElement(new Option("\tThe number of instances in the datasets (default 100).", "N", 1, "-N <num>"));
        newVector.addElement(new Option("\tFull name of the estimator analysed.\n\teg: weka.estimators.NormalEstimator", "W", 1, "-W"));
        if (this.m_Estimator != null && this.m_Estimator instanceof OptionHandler) {
            newVector.addElement(new Option("", "", 0, "\nOptions specific to estimator " + this.m_Estimator.getClass().getName() + ":"));
            Enumeration enu = this.m_Estimator.listOptions();
            while (enu.hasMoreElements()) {
                newVector.addElement((Option)enu.nextElement());
            }
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setDebug(Utils.getFlag('D', options));
        this.setSilent(Utils.getFlag('S', options));
        String tmpStr = Utils.getOption('N', options);
        if (tmpStr.length() != 0) {
            this.setNumInstances(Integer.parseInt(tmpStr));
        } else {
            this.setNumInstances(100);
        }
        tmpStr = Utils.getOption('W', options);
        if (tmpStr.length() == 0) {
            throw new Exception("A estimator must be specified with the -W option.");
        }
        this.setEstimator(Estimator.forName(tmpStr, Utils.partitionOptions(options)));
    }

    @Override
    public String[] getOptions() {
        String[] options;
        Vector<String> result = new Vector<String>();
        if (this.getDebug()) {
            result.add("-D");
        }
        if (this.getSilent()) {
            result.add("-S");
        }
        result.add("-N");
        result.add("" + this.getNumInstances());
        if (this.getEstimator() != null) {
            result.add("-W");
            result.add(this.getEstimator().getClass().getName());
        }
        if ((options = this.m_Estimator != null && this.m_Estimator instanceof OptionHandler ? this.m_Estimator.getOptions() : new String[]{}).length > 0) {
            result.add("--");
            int i = 0;
            while (i < options.length) {
                result.add(options[i]);
                ++i;
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public void setPostProcessor(PostProcessor value) {
        this.m_PostProcessor = value;
    }

    public PostProcessor getPostProcessor() {
        return this.m_PostProcessor;
    }

    public boolean hasClasspathProblems() {
        return this.m_ClasspathProblems;
    }

    public void doTests() {
        if (this.getEstimator() == null) {
            this.println("\n=== No estimator set ===");
            return;
        }
        this.println("\n=== Check on Estimator: " + this.getEstimator().getClass().getName() + " ===\n");
        this.m_ClasspathProblems = false;
        this.canTakeOptions();
        EstTypes estTypes = new EstTypes();
        estTypes.incremental = this.incrementalEstimator()[0];
        estTypes.weighted = this.weightedInstancesHandler()[0];
        estTypes.supervised = this.supervisedEstimator()[0];
        int classType = 1;
        AttrTypes attrTypes = this.testsPerClassType(classType, estTypes);
        this.canSplitUpClass(attrTypes, classType);
    }

    public void setDebug(boolean debug) {
        this.m_Debug = debug;
        if (this.getDebug()) {
            this.setSilent(false);
        }
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public void setSilent(boolean value) {
        this.m_Silent = value;
    }

    public boolean getSilent() {
        return this.m_Silent;
    }

    public void setNumInstances(int value) {
        this.m_NumInstances = value;
    }

    public int getNumInstances() {
        return this.m_NumInstances;
    }

    public void setEstimator(Estimator newEstimator) {
        this.m_Estimator = newEstimator;
    }

    public Estimator getEstimator() {
        return this.m_Estimator;
    }

    protected void print(Object msg) {
        if (!this.getSilent()) {
            System.out.print(msg);
        }
    }

    protected void println(Object msg) {
        this.print(msg + "\n");
    }

    protected void println() {
        this.print("\n");
    }

    protected AttrTypes testsPerClassType(int classType, EstTypes estTypes) {
        AttrTypes attrTypes = new AttrTypes();
        AttrTypes at = new AttrTypes(1);
        attrTypes.nominal = this.canEstimate(at, estTypes.supervised, classType)[0];
        at = new AttrTypes(0);
        attrTypes.numeric = this.canEstimate(at, estTypes.supervised, classType)[0];
        attrTypes.string = false;
        attrTypes.date = false;
        attrTypes.relational = false;
        if (attrTypes.oneIsSet()) {
            Vector attributesSet = attrTypes.getVectorOfAttrTypes();
            int i = 0;
            while (i < attributesSet.size()) {
                boolean handleMissingClass;
                AttrTypes workAttrTypes = new AttrTypes((Integer)attributesSet.elementAt(i));
                if (estTypes.weighted) {
                    this.instanceWeights(workAttrTypes, classType);
                }
                if (classType == 1) {
                    int numClasses = 4;
                    this.canHandleNClasses(workAttrTypes, numClasses);
                }
                int numAtt = 4;
                this.canHandleClassAsNthAttribute(workAttrTypes, numAtt, 0, classType, 1);
                this.canHandleZeroTraining(workAttrTypes, classType);
                boolean handleMissingAttributes = this.canHandleMissing(workAttrTypes, classType, true, false, 20)[0];
                if (handleMissingAttributes) {
                    this.canHandleMissing(workAttrTypes, classType, true, false, 100);
                }
                if (handleMissingClass = this.canHandleMissing(workAttrTypes, classType, false, true, 20)[0]) {
                    this.canHandleMissing(workAttrTypes, classType, false, true, 100);
                }
                this.correctBuildInitialisation(workAttrTypes, classType);
                this.datasetIntegrity(workAttrTypes, classType, handleMissingAttributes, handleMissingClass);
                if (estTypes.incremental) {
                    this.incrementingEquality(workAttrTypes, classType);
                }
                ++i;
            }
        }
        return attrTypes;
    }

    protected boolean[] canTakeOptions() {
        boolean[] result = new boolean[2];
        this.print("options...");
        if (this.m_Estimator instanceof OptionHandler) {
            this.println("yes");
            if (this.m_Debug) {
                this.println("\n=== Full report ===");
                Enumeration enu = this.m_Estimator.listOptions();
                while (enu.hasMoreElements()) {
                    Option option = (Option)enu.nextElement();
                    this.print(String.valueOf(option.synopsis()) + "\n" + option.description() + "\n");
                }
                this.println("\n");
            }
            result[0] = true;
        } else {
            this.println("no");
            result[0] = false;
        }
        return result;
    }

    protected boolean[] incrementalEstimator() {
        boolean[] result = new boolean[2];
        this.print("incremental estimator...");
        if (this.m_Estimator instanceof IncrementalEstimator) {
            this.println("yes");
            result[0] = true;
        } else {
            this.println("no");
            result[0] = false;
        }
        return result;
    }

    protected boolean[] weightedInstancesHandler() {
        boolean[] result = new boolean[2];
        this.print("weighted instances estimator...");
        if (this.m_Estimator instanceof WeightedInstancesHandler) {
            this.println("yes");
            result[0] = true;
        } else {
            this.println("no");
            result[0] = false;
        }
        return result;
    }

    protected boolean[] supervisedEstimator() {
        boolean[] result = new boolean[2];
        result[0] = false;
        return result;
    }

    protected boolean[] canEstimate(AttrTypes attrTypes, boolean supervised, int classType) {
        this.print("basic estimation");
        this.printAttributeSummary(attrTypes, classType);
        this.print("...");
        FastVector<String> accepts = new FastVector<String>();
        accepts.addElement("nominal");
        accepts.addElement("numeric");
        accepts.addElement("string");
        accepts.addElement("date");
        accepts.addElement("relational");
        accepts.addElement("not in classpath");
        int numTrain = this.getNumInstances();
        int numTest = this.getNumInstances();
        int numClasses = 2;
        int missingLevel = 0;
        boolean attributeMissing = false;
        boolean classMissing = false;
        int numAtts = 1;
        int attrIndex = 0;
        return this.runBasicTest(attrTypes, numAtts, attrIndex, classType, missingLevel, attributeMissing, classMissing, numTrain, numTest, numClasses, accepts);
    }

    protected void canSplitUpClass(AttrTypes attrTypes, int classType) {
        if (attrTypes.nominal) {
            this.canSplitUpClass(1, classType);
        }
        if (attrTypes.numeric) {
            this.canSplitUpClass(0, classType);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean[] canSplitUpClass(int attrType, int classType) {
        block14: {
            result = new boolean[2];
            accepts = new FastVector<String>();
            accepts.addElement("not in classpath");
            this.print("split per class type ");
            this.printAttributeSummary(attrType, 1);
            this.print("...");
            numTrain = this.getNumInstances();
            numTest = this.getNumInstances();
            numClasses = 2;
            attributeMissing = false;
            classMissing = false;
            numAtts = 3;
            attrIndex = 0;
            classIndex = 1;
            train = null;
            estimator = null;
            built = false;
            try {
                at = new AttrTypes(attrType);
                train = this.makeTestDataset(42, numTrain, numAtts, at, numClasses, classType, classIndex);
                test = this.makeTestValueList(24, numTest, train, attrIndex, attrType);
                estimator = Estimator.makeCopies(this.getEstimator(), 1)[0];
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new Error("Error setting up for tests: " + ex.getMessage());
            }
            try {
                estimator.addValues(train, attrIndex, classType, classIndex);
                built = true;
                this.testWithTestValues(estimator, test);
                this.println("yes");
                result[0] = true;
                break block14;
            }
            catch (Exception ex) {
                acceptable = false;
                msg = ex.getMessage() == null ? "" : ex.getMessage().toLowerCase();
                if (msg.indexOf("not in classpath") > -1) {
                    this.m_ClasspathProblems = true;
                }
                i = 0;
                ** while (i < accepts.size())
            }
lbl-1000:
            // 1 sources

            {
                if (msg.indexOf((String)accepts.elementAt(i)) >= 0) {
                    acceptable = true;
                }
                ++i;
                continue;
            }
lbl46:
            // 1 sources

            this.println("no" + (acceptable != false ? " (OK error message)" : ""));
            result[1] = acceptable;
            if (this.m_Debug) {
                this.println("\n=== Full Report ===");
                this.print("Problem during");
                if (built) {
                    this.print(" testing");
                } else {
                    this.print(" training");
                }
                this.println(": " + ex.getMessage() + "\n");
                if (!acceptable) {
                    if (accepts.size() > 0) {
                        this.print("Error message doesn't mention ");
                        i = 0;
                        while (i < accepts.size()) {
                            if (i != 0) {
                                this.print(" or ");
                            }
                            this.print(String.valueOf('\"') + (String)accepts.elementAt(i) + '\"');
                            ++i;
                        }
                    }
                    this.println("here are the datasets:\n");
                    this.println("=== Train Dataset ===\n" + train.toString() + "\n");
                    this.println("=== Test Dataset ===\n" + test.toString() + "\n\n");
                }
            }
        }
        return result;
    }

    protected boolean[] canHandleNClasses(AttrTypes attrTypes, int numClasses) {
        this.print("more than two class problems");
        this.printAttributeSummary(attrTypes, 1);
        this.print("...");
        FastVector<String> accepts = new FastVector<String>();
        accepts.addElement("number");
        accepts.addElement("class");
        int numTrain = this.getNumInstances();
        int numTest = this.getNumInstances();
        int missingLevel = 0;
        boolean attributeMissing = false;
        boolean classMissing = false;
        int numAttr = 1;
        int attrIndex = 0;
        return this.runBasicTest(attrTypes, numAttr, attrIndex, 1, missingLevel, attributeMissing, classMissing, numTrain, numTest, numClasses, accepts);
    }

    protected boolean[] canHandleClassAsNthAttribute(AttrTypes attrTypes, int numAtts, int attrIndex, int classType, int classIndex) {
        if (classIndex == -1) {
            this.print("class attribute as last attribute");
        } else {
            this.print("class attribute as " + (classIndex + 1) + ". attribute");
        }
        this.printAttributeSummary(attrTypes, classType);
        this.print("...");
        FastVector accepts = new FastVector();
        int numTrain = this.getNumInstances();
        int numTest = this.getNumInstances();
        int numClasses = 2;
        int missingLevel = 0;
        boolean attributeMissing = false;
        boolean classMissing = false;
        return this.runBasicTest(attrTypes, numAtts, attrIndex, classType, classIndex, missingLevel, attributeMissing, classMissing, numTrain, numTest, numClasses, accepts);
    }

    protected boolean[] canHandleZeroTraining(AttrTypes attrTypes, int classType) {
        this.print("handle zero training instances");
        this.printAttributeSummary(attrTypes, classType);
        this.print("...");
        FastVector<String> accepts = new FastVector<String>();
        accepts.addElement("train");
        accepts.addElement("value");
        int numTrain = 0;
        int numTest = this.getNumInstances();
        int numClasses = 2;
        int missingLevel = 0;
        boolean attributeMissing = false;
        boolean classMissing = false;
        int numAtts = 1;
        int attrIndex = 0;
        return this.runBasicTest(attrTypes, numAtts, attrIndex, classType, missingLevel, attributeMissing, classMissing, numTrain, numTest, numClasses, accepts);
    }

    protected boolean[] correctBuildInitialisation(AttrTypes attrTypes, int classType) {
        boolean[] result;
        block17: {
            result = new boolean[2];
            this.print("correct initialisation during buildEstimator");
            this.printAttributeSummary(attrTypes, classType);
            this.print("...");
            int numTrain = this.getNumInstances();
            int numTest = this.getNumInstances();
            int numClasses = 2;
            int missingLevel = 0;
            boolean attributeMissing = false;
            boolean classMissing = false;
            Instances train1 = null;
            Instances test1 = null;
            Instances train2 = null;
            Instances test2 = null;
            Estimator estimator = null;
            Estimator estimator1 = null;
            boolean built = false;
            int stage = 0;
            int attrIndex1 = 1;
            int attrIndex2 = 2;
            try {
                train1 = this.makeTestDataset(42, numTrain, 2, attrTypes, numClasses, classType);
                train2 = this.makeTestDataset(84, numTrain, 3, attrTypes, numClasses, classType);
                if (missingLevel > 0) {
                    this.addMissing(train1, missingLevel, attributeMissing, classMissing, attrIndex1);
                    this.addMissing(train2, missingLevel, attributeMissing, classMissing, attrIndex2);
                }
                estimator = Estimator.makeCopies(this.getEstimator(), 1)[0];
            }
            catch (Exception ex) {
                throw new Error("Error setting up for tests: " + ex.getMessage());
            }
            try {
                stage = 0;
                estimator.addValues(train1, attrIndex1);
                built = true;
                estimator1 = Estimator.makeCopies(this.getEstimator(), 1)[0];
                stage = 1;
                built = false;
                estimator.addValues(train2, attrIndex2);
                built = true;
                stage = 2;
                built = false;
                estimator.addValues(train1, attrIndex1);
                built = true;
                stage = 3;
                if (!estimator.equals(estimator1)) {
                    if (this.m_Debug) {
                        this.println("\n=== Full report ===\n\nFirst build estimator\n" + estimator.toString() + "\n\n");
                        this.println("\nSecond build estimator\n" + estimator.toString() + "\n\n");
                    }
                    throw new Exception("Results differ between buildEstimator calls");
                }
                this.println("yes");
                result[0] = true;
            }
            catch (Exception ex) {
                String msg = ex.getMessage().toLowerCase();
                if (msg.indexOf("worse than zeror") >= 0) {
                    this.println("warning: performs worse than ZeroR");
                    result[0] = true;
                    result[1] = true;
                } else {
                    this.println("no");
                    result[0] = false;
                }
                if (!this.m_Debug) break block17;
                this.println("\n=== Full Report ===");
                this.print("Problem during");
                if (built) {
                    this.print(" testing");
                } else {
                    this.print(" training");
                }
                switch (stage) {
                    case 0: {
                        this.print(" of dataset 1");
                        break;
                    }
                    case 1: {
                        this.print(" of dataset 2");
                        break;
                    }
                    case 2: {
                        this.print(" of dataset 1 (2nd build)");
                        break;
                    }
                    case 3: {
                        this.print(", comparing results from builds of dataset 1");
                    }
                }
                this.println(": " + ex.getMessage() + "\n");
                this.println("here are the datasets:\n");
                this.println("=== Train1 Dataset ===\n" + train1.toString() + "\n");
                this.println("=== Test1 Dataset ===\n" + test1.toString() + "\n\n");
                this.println("=== Train2 Dataset ===\n" + train2.toString() + "\n");
                this.println("=== Test2 Dataset ===\n" + test2.toString() + "\n\n");
            }
        }
        return result;
    }

    protected boolean[] canHandleMissing(AttrTypes attrTypes, int classType, boolean attributeMissing, boolean classMissing, int missingLevel) {
        if (missingLevel == 100) {
            this.print("100% ");
        }
        this.print("missing");
        if (attributeMissing) {
            this.print(" attribute");
            if (classMissing) {
                this.print(" and");
            }
        }
        if (classMissing) {
            this.print(" class");
        }
        this.print(" values");
        this.printAttributeSummary(attrTypes, classType);
        this.print("...");
        FastVector<String> accepts = new FastVector<String>();
        accepts.addElement("missing");
        accepts.addElement("value");
        accepts.addElement("train");
        int numTrain = this.getNumInstances();
        int numTest = this.getNumInstances();
        int numClasses = 2;
        int numAtts = 1;
        int attrIndex = 0;
        return this.runBasicTest(attrTypes, numAtts, attrIndex, classType, missingLevel, attributeMissing, classMissing, numTrain, numTest, numClasses, accepts);
    }

    protected boolean[] incrementingEquality(AttrTypes attrTypes, int classType) {
        Vector test;
        this.print("incremental training produces the same results as batch training");
        this.printAttributeSummary(attrTypes, classType);
        this.print("...");
        int numTrain = this.getNumInstances();
        int numTest = this.getNumInstances();
        int numClasses = 2;
        int missingLevel = 0;
        boolean attributeMissing = false;
        boolean classMissing = false;
        boolean[] result = new boolean[2];
        Instances train = null;
        Estimator[] estimators = null;
        boolean built = false;
        int attrIndex = 0;
        try {
            train = this.makeTestDataset(42, numTrain, 1, attrTypes, numClasses, classType);
            test = this.makeTestValueList(24, numTest, train, attrIndex, attrTypes.getSetType());
            if (missingLevel > 0) {
                this.addMissing(train, missingLevel, attributeMissing, classMissing, attrIndex);
            }
            estimators = Estimator.makeCopies(this.getEstimator(), 2);
            estimators[0].addValues(train, attrIndex);
        }
        catch (Exception ex) {
            throw new Error("Error setting up for tests: " + ex.getMessage());
        }
        try {
            int i = 0;
            while (i < train.numInstances()) {
                ((IncrementalEstimator)((Object)estimators[1])).addValue(train.instance(i).value(attrIndex), 1.0);
                ++i;
            }
            built = true;
            if (!estimators[0].equals(estimators[1])) {
                this.println("no");
                result[0] = false;
                if (this.m_Debug) {
                    this.println("\n=== Full Report ===");
                    this.println("Results differ between batch and incrementally built models.\nDepending on the estimator, this may be OK");
                    this.println("Here are the results:\n");
                    this.println("batch built results\n" + estimators[0].toString());
                    this.println("incrementally built results\n" + estimators[1].toString());
                    this.println("Here are the datasets:\n");
                    this.println("=== Train Dataset ===\n" + train.toString() + "\n");
                    this.println("=== Test Dataset ===\n" + test.toString() + "\n\n");
                }
            } else {
                this.println("yes");
                result[0] = true;
            }
        }
        catch (Exception ex) {
            result[0] = false;
            this.print("Problem during");
            if (built) {
                this.print(" testing");
            } else {
                this.print(" training");
            }
            this.println(": " + ex.getMessage() + "\n");
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean[] instanceWeights(AttrTypes attrTypes, int classType) {
        block13: {
            this.print("estimator uses instance weights");
            this.printAttributeSummary(attrTypes, classType);
            this.print("...");
            numTrain = 2 * this.getNumInstances();
            numTest = this.getNumInstances();
            numClasses = 2;
            missingLevel = 0;
            attributeMissing = false;
            classMissing = false;
            result = new boolean[2];
            train = null;
            test = null;
            estimators = null;
            resultProbsO = null;
            resultProbsW = null;
            built = false;
            evalFail = false;
            attrIndex = 0;
            try {
                train = this.makeTestDataset(42, numTrain, 1, attrTypes, numClasses, classType);
                test = this.makeTestValueList(24, numTest, train, attrIndex, attrTypes.getSetType());
                if (missingLevel > 0) {
                    this.addMissing(train, missingLevel, attributeMissing, classMissing, attrIndex);
                }
                estimators = Estimator.makeCopies(this.getEstimator(), 2);
                estimators[0].addValues(train, attrIndex);
                resultProbsO = this.testWithTestValues(estimators[0], test);
            }
            catch (Exception ex) {
                throw new Error("Error setting up for tests: " + ex.getMessage());
            }
            try {
                i = 0;
                while (i < train.numInstances()) {
                    train.instance(i).setWeight(0.0);
                    ++i;
                }
                random = new Random(1L);
                i = 0;
                while (i < train.numInstances() / 2) {
                    inst = Math.abs(random.nextInt()) % train.numInstances();
                    weight = Math.abs(random.nextInt()) % 10 + 1;
                    train.instance(inst).setWeight(weight);
                    ++i;
                }
                estimators[1].addValues(train, attrIndex);
                resultProbsW = this.testWithTestValues(estimators[1], test);
                built = true;
                if (resultProbsO.equals(resultProbsW)) {
                    evalFail = true;
                    throw new Exception("evalFail");
                }
                this.println("yes");
                result[0] = true;
                break block13;
            }
            catch (Exception ex) {
                this.println("no");
                result[0] = false;
                if (!this.m_Debug) break block13;
                this.println("\n=== Full Report ===");
                if (evalFail) {
                    this.println("Results don't differ between non-weighted and weighted instance models.");
                    this.println("Here are the results:\n");
                    this.println(this.probsToString(resultProbsO));
                } else {
                    this.print("Problem during");
                    if (built) {
                        this.print(" testing");
                    } else {
                        this.print(" training");
                    }
                    this.println(": " + ex.getMessage() + "\n");
                }
                this.println("Here are the datasets:\n");
                this.println("=== Train Dataset ===\n" + train.toString() + "\n");
                this.println("=== Train Weights ===\n");
                i = 0;
                ** while (i < train.numInstances())
            }
lbl-1000:
            // 1 sources

            {
                this.println(" " + (i + 1) + "    " + train.instance(i).weight());
                ++i;
                continue;
            }
lbl77:
            // 1 sources

            this.println("=== Test Dataset ===\n" + test.toString() + "\n\n");
            this.println("(test weights all 1.0\n");
        }
        return result;
    }

    protected boolean[] datasetIntegrity(AttrTypes attrTypes, int classType, boolean attributeMissing, boolean classMissing) {
        boolean[] result;
        block7: {
            Estimator estimator = null;
            this.print("estimator doesn't alter original datasets");
            this.printAttributeSummary(attrTypes, classType);
            this.print("...");
            int numTrain = this.getNumInstances();
            int numTest = this.getNumInstances();
            int numClasses = 2;
            int missingLevel = 100;
            result = new boolean[2];
            Instances train = null;
            boolean built = false;
            try {
                train = this.makeTestDataset(42, numTrain, 1, attrTypes, numClasses, classType);
                int attrIndex = 0;
                if (missingLevel > 0) {
                    this.addMissing(train, missingLevel, attributeMissing, classMissing, attrIndex);
                }
                estimator = Estimator.makeCopies(this.getEstimator(), 1)[0];
            }
            catch (Exception ex) {
                throw new Error("Error setting up for tests: " + ex.getMessage());
            }
            try {
                Instances trainCopy = new Instances(train);
                int attrIndex = 0;
                estimator.addValues(trainCopy, attrIndex);
                this.compareDatasets(train, trainCopy);
                built = true;
                this.println("yes");
                result[0] = true;
            }
            catch (Exception ex) {
                this.println("no");
                result[0] = false;
                if (!this.m_Debug) break block7;
                this.println("\n=== Full Report ===");
                this.print("Problem during");
                if (built) {
                    this.print(" testing");
                } else {
                    this.print(" training");
                }
                this.println(": " + ex.getMessage() + "\n");
                this.println("Here are the datasets:\n");
                this.println("=== Train Dataset ===\n" + train.toString() + "\n");
            }
        }
        return result;
    }

    protected boolean[] runBasicTest(AttrTypes attrTypes, int numAtts, int attrIndex, int classType, int missingLevel, boolean attributeMissing, boolean classMissing, int numTrain, int numTest, int numClasses, FastVector accepts) {
        return this.runBasicTest(attrTypes, numAtts, attrIndex, classType, -1, missingLevel, attributeMissing, classMissing, numTrain, numTest, numClasses, accepts);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean[] runBasicTest(AttrTypes attrTypes, int numAtts, int attrIndex, int classType, int classIndex, int missingLevel, boolean attributeMissing, boolean classMissing, int numTrain, int numTest, int numClasses, FastVector accepts) {
        block17: {
            result = new boolean[2];
            train = null;
            test = null;
            estimator = null;
            built = false;
            try {
                train = this.makeTestDataset(42, numTrain, numAtts, attrTypes, numClasses, classType, classIndex);
                if (numTrain > 0) {
                    test = this.makeTestValueList(24, numTest, train, attrIndex, attrTypes.getSetType());
                } else {
                    min = -10.0;
                    max = 8.0;
                    test = this.makeTestValueList(24, numTest, min, max, attrTypes.getSetType());
                }
                if (missingLevel > 0) {
                    this.addMissing(train, missingLevel, attributeMissing, classMissing, attrIndex);
                }
                estimator = Estimator.makeCopies(this.getEstimator(), 1)[0];
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new Error("Error setting up for tests: " + ex.getMessage());
            }
            try {
                estimator.addValues(train, attrIndex);
                built = true;
                this.testWithTestValues(estimator, test);
                this.println("yes");
                result[0] = true;
                break block17;
            }
            catch (Exception ex) {
                acceptable = false;
                msg = ex.getMessage() == null ? "" : ex.getMessage().toLowerCase();
                if (msg.indexOf("not in classpath") > -1) {
                    this.m_ClasspathProblems = true;
                }
                i = 0;
                ** while (i < accepts.size())
            }
lbl-1000:
            // 1 sources

            {
                if (msg.indexOf((String)accepts.elementAt(i)) >= 0) {
                    acceptable = true;
                }
                ++i;
                continue;
            }
lbl40:
            // 1 sources

            this.println("no" + (acceptable != false ? " (OK error message)" : ""));
            result[1] = acceptable;
            if (this.m_Debug) {
                this.println("\n=== Full Report ===");
                this.print("Problem during");
                if (built) {
                    this.print(" testing");
                } else {
                    this.print(" training");
                }
                this.println(": " + ex.getMessage() + "\n");
                if (!acceptable) {
                    if (accepts.size() > 0) {
                        this.print("Error message doesn't mention ");
                        i = 0;
                        while (i < accepts.size()) {
                            if (i != 0) {
                                this.print(" or ");
                            }
                            this.print(String.valueOf('\"') + (String)accepts.elementAt(i) + '\"');
                            ++i;
                        }
                    }
                    this.println("here are the datasets:\n");
                    this.println("=== Train Dataset ===\n" + train.toString() + "\n");
                    this.println("=== Test Dataset ===\n" + test.toString() + "\n\n");
                }
            }
        }
        return result;
    }

    protected void compareDatasets(Instances data1, Instances data2) throws Exception {
        if (!data2.equalHeaders(data1)) {
            throw new Exception("header has been modified\n" + data2.equalHeadersMsg(data1));
        }
        if (data2.numInstances() != data1.numInstances()) {
            throw new Exception("number of instances has changed");
        }
        int i = 0;
        while (i < data2.numInstances()) {
            Instance orig = data1.instance(i);
            Instance copy = data2.instance(i);
            int j = 0;
            while (j < orig.numAttributes()) {
                if (orig.isMissing(j) ? !copy.isMissing(j) : orig.value(j) != copy.value(j)) {
                    throw new Exception("instances have changed");
                }
                if (orig.weight() != copy.weight()) {
                    throw new Exception("instance weights have changed");
                }
                ++j;
            }
            ++i;
        }
    }

    protected void addMissing(Instances data, int level, boolean attributeMissing, boolean classMissing, int attrIndex) {
        int classIndex = data.classIndex();
        Random random = new Random(1L);
        int i = 0;
        while (i < data.numInstances()) {
            Instance current = data.instance(i);
            int j = 0;
            while (j < data.numAttributes()) {
                if ((j == classIndex && classMissing || j == attrIndex && attributeMissing) && Math.abs(random.nextInt()) % 100 < level) {
                    current.setMissing(j);
                }
                ++j;
            }
            ++i;
        }
    }

    protected Instances makeTestDataset(int seed, int numInstances, int numAttr, AttrTypes attrTypes, int numClasses, int classType) throws Exception {
        return this.makeTestDataset(seed, numInstances, numAttr, attrTypes, numClasses, classType, -1);
    }

    protected Instances makeTestDataset(int seed, int numInstances, int numAttr, AttrTypes attrTypes, int numClasses, int classType, int classIndex) throws Exception {
        TestInstances dataset = new TestInstances();
        dataset.setSeed(seed);
        dataset.setNumInstances(numInstances);
        dataset.setNumNominal(attrTypes.nominal ? numAttr : 0);
        dataset.setNumNumeric(attrTypes.numeric ? numAttr : 0);
        dataset.setNumString(attrTypes.string ? numAttr : 0);
        dataset.setNumDate(attrTypes.date ? numAttr : 0);
        dataset.setNumRelational(attrTypes.relational ? numAttr : 0);
        dataset.setNumClasses(numClasses);
        dataset.setClassType(classType);
        dataset.setClassIndex(classIndex);
        return this.process(dataset.generate());
    }

    protected Vector makeTestValueList(int seed, int numValues, Instances data, int attrIndex, int attrType) throws Exception {
        Double v;
        int i;
        double[] minMax = this.getMinimumMaximum(data, attrIndex);
        double minValue = minMax[0];
        double maxValue = minMax[1];
        double range = maxValue - minValue;
        Vector<Double> values = new Vector<Double>(numValues);
        Random random = new Random(seed);
        if (attrType == 1) {
            i = 0;
            while (i < numValues) {
                v = new Double(Math.abs(random.nextInt()) % (int)range + (int)minValue);
                values.add(v);
                ++i;
            }
        }
        if (attrType == 0) {
            i = 0;
            while (i < numValues) {
                v = new Double(random.nextDouble() * range + minValue);
                values.add(v);
                ++i;
            }
        }
        return values;
    }

    protected Vector makeTestValueList(int seed, int numValues, double minValue, double maxValue, int attrType) throws Exception {
        Double v;
        int i;
        double range = maxValue - minValue;
        Vector<Double> values = new Vector<Double>(numValues);
        Random random = new Random(seed);
        if (attrType == 1) {
            i = 0;
            while (i < numValues) {
                v = new Double(Math.abs(random.nextInt()) % (int)range + (int)minValue);
                values.add(v);
                ++i;
            }
        }
        if (attrType == 0) {
            i = 0;
            while (i < numValues) {
                v = new Double(random.nextDouble() * range + minValue);
                values.add(v);
                ++i;
            }
        }
        return values;
    }

    protected Vector testWithTestValues(Estimator est, Vector test) {
        Vector<Double> results = new Vector<Double>();
        int i = 0;
        while (i < test.size()) {
            double testValue = (Double)test.elementAt(i);
            double prob = est.getProbability(testValue);
            Double p = new Double(prob);
            results.add(p);
            ++i;
        }
        return results;
    }

    protected double[] getMinimumMaximum(Instances inst, int attrIndex) {
        double[] minMax = new double[2];
        try {
            int n = CheckEstimator.getMinMax(inst, attrIndex, minMax);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(ex.getMessage());
        }
        return minMax;
    }

    public static int getMinMax(Instances inst, int attrIndex, double[] minMax) throws Exception {
        double min = Double.NaN;
        double max = Double.NaN;
        Instance instance = null;
        int numNotMissing = 0;
        if (minMax == null || minMax.length < 2) {
            throw new Exception("Error in Program, privat method getMinMax");
        }
        Enumeration enumInst = inst.enumerateInstances();
        if (enumInst.hasMoreElements()) {
            while ((instance = (Instance)enumInst.nextElement()).isMissing(attrIndex) && enumInst.hasMoreElements()) {
            }
            if (!instance.isMissing(attrIndex)) {
                ++numNotMissing;
                min = instance.value(attrIndex);
                max = instance.value(attrIndex);
            }
            while (enumInst.hasMoreElements()) {
                instance = (Instance)enumInst.nextElement();
                if (instance.isMissing(attrIndex)) continue;
                ++numNotMissing;
                if (instance.value(attrIndex) < min) {
                    min = instance.value(attrIndex);
                    continue;
                }
                if (!(instance.value(attrIndex) > max)) continue;
                max = instance.value(attrIndex);
            }
        }
        minMax[0] = min;
        minMax[1] = max;
        return numNotMissing;
    }

    private String probsToString(Vector probs) {
        StringBuffer txt = new StringBuffer(" ");
        int i = 0;
        while (i < probs.size()) {
            txt.append((Double)probs.elementAt(i) + " ");
            ++i;
        }
        return txt.toString();
    }

    protected Instances process(Instances data) {
        if (this.getPostProcessor() == null) {
            return data;
        }
        return this.getPostProcessor().process(data);
    }

    protected void printAttributeSummary(AttrTypes attrTypes, int classType) {
        String str = "";
        if (attrTypes.numeric) {
            str = String.valueOf(str) + " numeric";
        }
        if (attrTypes.nominal) {
            if (str.length() > 0) {
                str = String.valueOf(str) + " &";
            }
            str = String.valueOf(str) + " nominal";
        }
        if (attrTypes.string) {
            if (str.length() > 0) {
                str = String.valueOf(str) + " &";
            }
            str = String.valueOf(str) + " string";
        }
        if (attrTypes.date) {
            if (str.length() > 0) {
                str = String.valueOf(str) + " &";
            }
            str = String.valueOf(str) + " date";
        }
        if (attrTypes.relational) {
            if (str.length() > 0) {
                str = String.valueOf(str) + " &";
            }
            str = String.valueOf(str) + " relational";
        }
        str = String.valueOf(str) + " attributes)";
        switch (classType) {
            case 0: {
                str = " (numeric class," + str;
                break;
            }
            case 1: {
                str = " (nominal class," + str;
                break;
            }
            case 2: {
                str = " (string class," + str;
                break;
            }
            case 3: {
                str = " (date class," + str;
                break;
            }
            case 4: {
                str = " (relational class," + str;
            }
        }
        this.print(str);
    }

    protected void printAttributeSummary(int attrType, int classType) {
        String str = "";
        switch (attrType) {
            case 0: {
                str = " numeric" + str;
                break;
            }
            case 1: {
                str = " nominal" + str;
                break;
            }
            case 2: {
                str = " string" + str;
                break;
            }
            case 3: {
                str = " date" + str;
                break;
            }
            case 4: {
                str = " relational" + str;
            }
        }
        str = String.valueOf(str) + " attribute(s))";
        switch (classType) {
            case 0: {
                str = " (numeric class," + str;
                break;
            }
            case 1: {
                str = " (nominal class," + str;
                break;
            }
            case 2: {
                str = " (string class," + str;
                break;
            }
            case 3: {
                str = " (date class," + str;
                break;
            }
            case 4: {
                str = " (relational class," + str;
            }
        }
        this.print(str);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        try {
            block5: {
                check = new CheckEstimator();
                try {
                    check.setOptions(args);
                    Utils.checkForRemainingOptions(args);
                    break block5;
                }
                catch (Exception ex) {
                    result = String.valueOf(ex.getMessage()) + "\n\n" + check.getClass().getName().replaceAll(".*\\.", "") + " Options:\n\n";
                    enu = check.listOptions();
                    ** while (enu.hasMoreElements())
                }
lbl-1000:
                // 1 sources

                {
                    option = (Option)enu.nextElement();
                    result = String.valueOf(result) + option.synopsis() + "\n" + option.description() + "\n";
                    continue;
                }
lbl14:
                // 1 sources

                throw new Exception(result);
            }
            check.doTests();
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    public static class AttrTypes
    implements RevisionHandler {
        boolean nominal = false;
        boolean numeric = false;
        boolean string = false;
        boolean date = false;
        boolean relational = false;

        AttrTypes() {
        }

        AttrTypes(AttrTypes newTypes) {
            this.nominal = newTypes.nominal;
            this.numeric = newTypes.numeric;
            this.string = newTypes.string;
            this.date = newTypes.date;
            this.relational = newTypes.relational;
        }

        AttrTypes(int type) {
            if (type == 1) {
                this.nominal = true;
            }
            if (type == 0) {
                this.numeric = true;
            }
            if (type == 2) {
                this.string = true;
            }
            if (type == 3) {
                this.date = true;
            }
            if (type == 4) {
                this.relational = true;
            }
        }

        int getSetType() throws Exception {
            int sum = 0;
            int type = -1;
            if (this.nominal) {
                ++sum;
                type = 1;
            }
            if (this.numeric) {
                ++sum;
                type = 0;
            }
            if (this.string) {
                ++sum;
                type = 2;
            }
            if (this.date) {
                ++sum;
                type = 3;
            }
            if (this.relational) {
                ++sum;
                type = 4;
            }
            if (sum > 1) {
                throw new Exception("Expected to have only one type set used wrongly.");
            }
            if (type < 0) {
                throw new Exception("No type set.");
            }
            return type;
        }

        boolean oneIsSet() {
            return this.nominal || this.numeric || this.string || this.date || this.relational;
        }

        public Vector getVectorOfAttrTypes() {
            Vector<Integer> attrs = new Vector<Integer>();
            if (this.nominal) {
                attrs.add(new Integer(1));
            }
            if (this.numeric) {
                attrs.add(new Integer(0));
            }
            if (this.string) {
                attrs.add(new Integer(2));
            }
            if (this.date) {
                attrs.add(new Integer(3));
            }
            if (this.relational) {
                attrs.add(new Integer(4));
            }
            return attrs;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 8034 $");
        }
    }

    public static class EstTypes
    implements RevisionHandler {
        boolean incremental = false;
        boolean weighted = false;
        boolean supervised = false;

        public EstTypes() {
        }

        public EstTypes(boolean i, boolean w, boolean s) {
            this.incremental = i;
            this.weighted = w;
            this.supervised = s;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 8034 $");
        }
    }

    public class PostProcessor
    implements RevisionHandler {
        protected Instances process(Instances data) {
            return data;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 8034 $");
        }
    }
}

